/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.expression.aggregate;

import java.util.TreeMap;
import org.h14199.engine.Database;
import org.h14199.expression.aggregate.AggregateData;
import org.h14199.expression.aggregate.LongDataCounter;
import org.h14199.value.Value;
import org.h14199.value.ValueNull;

class AggregateDataDistinctWithCounts
extends AggregateData {
    private final boolean ignoreNulls;
    private final int maxDistinctCount;
    private TreeMap<Value, LongDataCounter> values;

    AggregateDataDistinctWithCounts(boolean bl, int n) {
        this.ignoreNulls = bl;
        this.maxDistinctCount = n;
    }

    @Override
    void add(Database database, Value value) {
        LongDataCounter longDataCounter;
        if (this.ignoreNulls && value == ValueNull.INSTANCE) {
            return;
        }
        if (this.values == null) {
            this.values = new TreeMap(database.getCompareMode());
        }
        if ((longDataCounter = this.values.get(value)) == null) {
            if (this.values.size() >= this.maxDistinctCount) {
                return;
            }
            longDataCounter = new LongDataCounter();
            this.values.put(value, longDataCounter);
        }
        ++longDataCounter.count;
    }

    @Override
    Value getValue(Database database, int n) {
        return null;
    }

    TreeMap<Value, LongDataCounter> getValues() {
        return this.values;
    }
}

